//
//  IFont.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/8.
//

#ifndef IFont_h
#define IFont_h

// IFont.h
#import <Foundation/Foundation.h>

/**
 * \~English
 * @protocol IFont
 * @brief A protocol defining the interface for Font classes.
 * @ingroup Interface
 *
 * The IFont protocol specifies the properties and methods that a font class must implement.
 *
 * \~Chinese
 * @protocol IFont
 * @brief 定义字体类接口的协议。
 * @ingroup Interface
 *
 * IFont 协议指定了字体类必须实现的属性和方法。
 *
 * \~Chinese-Traditional
 * @protocol IFont
 * @brief 定義字體類接口的協議。
 * @ingroup Interface
 *
 * IFont 協議指定了字體類必須實現的屬性和方法。
 */
@protocol IFont <NSObject>

/**
 * \~English
 * @brief The name of the font to use.
 *
 * This property specifies the name of the font that should be used.
 *
 * \~Chinese
 * @brief 要使用的字体名称。
 *
 * 此属性指定应使用的字体的名称。
 *
 * \~Chinese-Traditional
 * @brief 要使用的字體名稱。
 *
 * 此屬性指定應使用的字體的名稱。
 */
@property (nonatomic, strong) NSString *fontName;

@end

#endif /* IFont_h */
