//
//  ABarcode1D.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/7.
//

#ifndef ABarcode1D_h
#define ABarcode1D_h

#import <Foundation/Foundation.h>

#import <UniPRT/IBarcode1D.h>

/**
 * @~english
 * @class ABarcode1D
 * @brief Base class for ABarcode1D barcode.
 * @ingroup Interface
 *
 * @~chinese
 * @class ABarcode1D
 * @brief ABarcode1D 条码的基类。
 * @ingroup Interface
 *
 * @~Chinese-Traditional
 * @class ABarcode1D
 * @brief ABarcode1D 條碼的基類。
 * @ingroup Interface
 */
@interface ABarcode1D : NSObject <IBarcode1D>

@property (nonatomic, strong) NSMutableArray<id<IBarcodeItem>> *barcodes;
@property (nonatomic) BarcodeTypeEnum1D barcodeType; // Adjusted for specific enum type
@property (nonatomic, strong) id<IRuler> ruler;
@property (nonatomic, strong) id<IBarWidths> barWidths;
@property (nonatomic, assign) BOOL printHumanReadable;
@property (nonatomic) RotateEnum rotation;

- (instancetype)init;
- (instancetype)initWithBarcodeItem:(id<IBarcodeItem>)barcode;

@end

#endif /* ABarcode1D_h */
 
