//
//  OdvMonitor.h
//  TSCPrinters SDK
//
//  Created by Realbuber on 2024/4/14.
//

#ifndef OdvMonitor_h
#define OdvMonitor_h


#endif /* OdvMonitor_h */
#import <Foundation/Foundation.h>
#import <AutoIdSDK/TcpComm.h>
#import <AutoIdSDK/JsonComm.h>
#import <AutoIdSDK/OdvReport.h>

@interface OdvMonitor : NSObject

@property (nonatomic, strong) NSString *DONT_CARE_ID;
@property (nonatomic, assign) BOOL odvReportListening;
@property (nonatomic, strong) NSThread *listenerThread;
@property (nonatomic, strong) id syncContext; // Assuming it's an NSObject or similar
@property (nonatomic, strong) NSString *managedDescriptor;

- (instancetype)initWithTcpComm:(TcpComm *)connection;
- (instancetype)initWithJsonComm:(JsonComm *)mgmtComm;
- (instancetype)initWithCommDescriptor:(NSString *)commDescriptor;
- (void)SetOdvReportListening:(BOOL)value;


typedef void (^OdvReportCallback)(OdvReport *report);
@property (nonatomic, copy) OdvReportCallback odvReportCallback;

@end
