//
//  PrinterMonitor.h
//  TSCPrinters SDK
//
//  Created by Realbuber on 2024/4/11.
//

#ifndef PrinterMonitor_h
#define PrinterMonitor_h


#endif /* PrinterMonitor_h */

#import <Foundation/Foundation.h>
#import <AutoIdSDK/TcpComm.h>
#import <AutoIdSDK/JsonComm.h>
#import <AutoIdSDK/PrinterInfo.h>
#import <AutoIdSDK/SynchronizationContext.h>
#import <AutoIdSDK/JsonCommController.h>
#import <AutoIdSDK/JsonStringBuilder.h>


@interface PrinterMonitor : NSObject

@property (nonatomic, strong) NSString *engineStatus;
@property (nonatomic, strong) NSArray<NSString *> *alertStatus;
@property (nonatomic, strong) NSArray<NSString *> *displayStatus;
@property (nonatomic, strong) NSString *DONT_CARE_ID;
@property (nonatomic) BOOL engineStatusListening;
@property (nonatomic) BOOL displayStatusListening;
@property (nonatomic) BOOL alertStatusListening;

- (instancetype)initWithTcpComm:(TcpComm *)connection;
- (instancetype)initWithJsonComm:(JsonComm *)mgmtComm;
- (instancetype)initWithCommDescriptor:(NSString *)commDescriptor;

- (PrinterInfo *)getPrinterInfo;
- (NSString *)getEngineStatus;
- (NSArray<NSString *> *)getFaultStatus;

- (void)SetEngineStatusListening:(BOOL)value;
- (void)SetDisplayStatusListening:(BOOL)value;
- (void)SetAlertStatusListening:(BOOL)value;

typedef void (^EngineStatusCallback)(NSString *newEngineState);
typedef void (^DisplayStatusCallback)(NSArray<NSString *> *panelText);
typedef void (^AlertStatusCallback)(NSArray<NSString *> *alertText);

@property (nonatomic, copy) EngineStatusCallback engineStatusCallback;
@property (nonatomic, copy) DisplayStatusCallback displayStatusCallback;
@property (nonatomic, copy) AlertStatusCallback alertStatusCallback;
//
//- (void)setEngineStatusCallback:(void (^)(NSString *status))callback;
//- (void)setDisplayStatusCallback:(void (^)(NSArray<NSString *> *status))callback;
//- (void)setAlertStatusCallback:(void (^)(NSArray<NSString *> *status))callback;

//@property (nonatomic, copy) void (^displayStatusUpdated)(NSArray<NSString *> *status);
//@property (nonatomic, copy) void (^alertStatusUpdated)(NSArray<NSString *> *status);
//@property (nonatomic, copy) void (^engineStatusUpdated)(NSString *status);


@end

