package com.test.UniPRTSdk;

import java.util.Arrays;
import com.UniPRT.Sdk.Json.RfidMonitor;
import com.UniPRT.Sdk.Json.RfidReport;

public class RfidMonitorSnippet {

    private static RfidMonitor _RfidReportListener = null;

    public static void test() {
        System.out.println("Listening for Rfid barcode reports.");
        try {
            //_RfidReportListener = new RfidMonitor("127.0.0.1");
            _RfidReportListener = new RfidMonitor("192.168.1.55");

            _RfidReportListener.SetRfidReportListening(true);   // enable parsing of unsolicited barcode report msgs from printer
            _RfidReportListener.SetRfidReportCallback(RfidMonitorSnippet::myRfidReportProcessing);  // set the callback/delegate to call when reports received

            while (true) {   // wait for something to happen
                // pretend to be busy doing some other work here...
                Thread.sleep(1000); // simulate work
            }
        } catch (Exception e) {
            System.out.printf("Exception Msg: %s%n", e.getMessage());
        } finally {
            if (_RfidReportListener != null) {
                _RfidReportListener.Dispose();
            }
        }
    }

    public static void myRfidReportProcessing(RfidReport report) {
        // this function called when RFID reports received.
        // Here we can read and use any part of the report as needed.
        // In our case, simply printing report contents to console but could write to file for archiving if needed

        if (report.Failed()) {
            System.out.println("\nRFID Failed.");
        } else {
            String memoryType = "";
            switch (report.DataType()) {
                case USR:
                    memoryType = "USR";
                    break;
                case TID:
                    memoryType = "TID";
                    break;
                case UNKNOWN:
                    memoryType = "UNKNOWN";
                    break;
            }

            System.out.println("\nRFID Passed.");
            System.out.printf("Write Action: %s%n", report.IsWriteOperation() ? "yes" : "no");
            System.out.printf("Operation on EPC Memory: %s%n", report.DataType() == RfidReport.RfidDataType.EPC ? "yes" : "no");
            if (report.DataType() != RfidReport.RfidDataType.EPC) {
                System.out.printf("  memory accessed: %s%n", memoryType);
            }

            System.out.printf("Data: \n %s%n", report.Data());
        }
    }
}
