from enum import Enum
from typing import List, Optional
from .ICoordinates import IPoint
from .IBarcode2D import ICellSquare, ABarcode2D, ISquareCell


class QRCodeMaskEnum(Enum):
    MASK0 = 0
    MASK1 = 1
    MASK2 = 2
    MASK3 = 3
    MASK4 = 4
    MASK5 = 5
    MASK6 = 6
    MASK7 = 7
    MASK8 = 8

class QRCodeModelEnum(Enum):
    MODEL1 = 0
    MODEL2 = 1

class QRCodeErrorCorrectionEnum(Enum):
    CORRECTION7 = 0  # 7% Error Correction, 'L' level
    CORRECTION15 = 1  # 15% Error Correction, 'M' level
    CORRECTION25 = 2  # 25% Error Correction, 'Q' level
    CORRECTION30 = 3  # 30% Error Correction, 'H' level

class QRCodeManualEncodingEnum(Enum):
    NUMERIC = 0
    ALPHA_NUMERIC = 1
    BINARY = 2
    KANJI = 3

class AQRBarcode(ABarcode2D, ISquareCell):
    start: IPoint
    data: str
    data_manually_encoded: Optional[List[List[str]]]
    mask: QRCodeMaskEnum
    model: QRCodeModelEnum
    error_correction: QRCodeErrorCorrectionEnum
    cell_size: ICellSquare