from enum import Enum
from typing import Protocol


class RotateEnum(Enum):
    """
    @enum RotateEnum
    @brief Direction/Rotation for objects commands that support rotation.
    @ingroup Interface

    - NONE: No rotation.
    - CLOCKWISE: 90 Degrees clockwise rotation.
    - COUNTER_CLOCKWISE: 90 Degrees counter clockwise rotation. 270 Degrees clockwise rotation.
    - INVERTED: 180 Degrees clockwise rotation.
    """
    NONE = 0
    CLOCKWISE = 1
    COUNTER_CLOCKWISE = 2
    INVERTED = 3


class AlignEnum(Enum):
    """
    @enum AlignEnum
    @brief AlignEnum type/formats.
    @ingroup Interface

    Alignment options of object within a plane.

    - DEFAULT: Default Align
    - LEFT: Left Align
    - CENTER: Center Align
    - RIGHT: Right Align
    """
    DEFAULT = 0
    LEFT = 1
    CENTER = 2
    RIGHT = 3


class IRotation(Protocol):
    """
    @protocol IRotation
    @brief The rotation of an object.
    @ingroup Interface
    """
    rotation: RotateEnum
