from typing import List, Optional
from ..Interfaces.ICoordinates import IPoint
from ..Interfaces.IBarcode1D import (
    ABarcode1D,
    ABarWidths,
    IBarcodeItem,
    BarcodeTypeEnum1D,
)
from ..Interfaces.Coordinate import Ruler
from ..Interfaces.ICoordinates import PrintPlane, ScaleEnum
from ..Interfaces.ISettings import RotateEnum
from .Translate import Translate
from ..PglLib.PglInterfaces import Barcode1D as PGLBarcode1D

class BarWidths(ABarWidths):
    def __init__(self, narrow_bar: float = 3.0 / 203.0, wide_bar: float = 2.1 * 3.0 / 203.0): ...
    def bcd_magnification_1d(self, bcd_type: BarcodeTypeEnum1D, pp: PrintPlane, bar_widths: "BarWidths") -> str: ...

class Barcode1D(ABarcode1D):
    def __init__(self, barcode: Optional[IBarcodeItem] = None): ...
    def __str__(self) -> str: ...
