from typing import List, Optional, Union
from ..Interfaces.Coordinate import Points
from ..Interfaces.IBcdQRCode import QRCodeManualEncodingEnum, QRCodeErrorCorrectionEnum, QRCodeModelEnum
from ..Interfaces.ISettings import RotateEnum

class QRBarcode:
    start: Optional[Points]
    data: Optional[str]
    data_manually_encoded: Optional[List[List[Union[QRCodeManualEncodingEnum, str]]]]
    error_correction: QRCodeErrorCorrectionEnum
    model: QRCodeModelEnum
    rotation: RotateEnum

    def __init__(self, start: Optional[Points] = None, data: Optional[str] = None, manually_encoded_data: Optional[List[List[Union[QRCodeManualEncodingEnum, str]]]] = None): ...
    
    def __str__(self) -> str: ...
