@import UniPRT;
#import <Foundation/Foundation.h>

#define MAX_INPUT_MSG_CAPACITY 20
#define MAX_WAIT_TIME_SECS 15

int main(int argc, const char * argv[]) {
    @autoreleasepool {
        
        NSString *ip = @"10.100.15.201";
        CommType commType = TCP_COMM;
        
        // Initialize TCP communication
        TcpComm *tcpComm = [[TcpComm alloc] initWithIPAddress:ip port:DEFAULT_MGMT_PORT];
        [tcpComm open];
        
        // Initialize JsonComm for TCP communication
        JsonComm *jsonComm = [[JsonComm alloc] initWithComm:tcpComm commType:commType];
        jsonComm.usingDataPort = YES;
        
        // Initialize SettingsReadWrite with JsonComm
        SettingsReadWrite *settingReadWrite = [[SettingsReadWrite alloc] initWithJsonComm:jsonComm];
        
        // Example usage: Get values for specific keys
        NSArray<NSString *> *partOfKeys = @[@"TCP.IPAddress", @"TCP.Port"];
        NSDictionary<NSString *, NSString *> *partOfValue = [settingReadWrite getValuesForKeys:partOfKeys];
        NSLog(@"Get keys::::%@", partOfValue);
        
        // Get all properties
        NSDictionary<NSString *, Setting *> *allProperties = [settingReadWrite getAllProperties];
        NSLog(@"All properties:::%@", allProperties);
        
        // Get properties for specific keys
        NSDictionary<NSString *, Setting *> *propkeys = [settingReadWrite getPropertiesForKeys:partOfKeys];
        NSLog(@"Prop keys:::%@", propkeys);
        
        // Get a specific property
        Setting *propkey = [settingReadWrite getPropertiesForKey:@"TCP.IPAddress"];
        NSLog(@"Property key:::%@", propkey);
        
        // Initialize JsonConfig with JsonComm for configuration handling
        JsonConfig *jsonconfig = [[JsonConfig alloc] initWithJsonComm:jsonComm];
        
        // Get all configurations
        NSArray<Config *> *allConfig = [jsonconfig getAllConfig];
        NSLog(@"All config:::\r\n%@", allConfig);
        
        CFRunLoopRun();  // Keeps the application running
    }
}
