//
//  PrinterInfo.h
//  TSCPrinters SDK
//
//  Created by Realbuber on 2024/4/10.
//

#ifndef PrinterInfo_h
#define PrinterInfo_h


#endif /* PrinterInfo_h */

#import <Foundation/Foundation.h>

/**
 * \~English
 * @class PrinterInfo
 * @brief Printer information class to show printer attributes and other useful information.
 * @ingroup Reports
 *
 * \~Chinese
 * @class PrinterInfo
 * @brief 打印机信息类，用于显示打印机属性和其他有用信息。
 * @ingroup Reports
 *
 * \~Chinese-Traditional
 * @class PrinterInfo
 * @brief 打印機信息類，用於顯示打印機屬性和其他有用信息。
 * @ingroup Reports
 */
@interface PrinterInfo : NSObject

/**
 * \~English
 * @brief The raw information dictionary containing printer details.
 *
 * \~Chinese
 * @brief 包含打印机详细信息的原始信息字典。
 *
 * \~Chinese-Traditional
 * @brief 包含打印機詳細信息的原始信息字典。
 */
@property (nonatomic, strong, readonly) NSDictionary<NSString *, NSString *> *rawInfo;

/**
 * \~English
 * @brief Sets the raw information dictionary.
 *
 * @param rawInfo The dictionary containing the raw printer information.
 *
 * \~Chinese
 * @brief 设置原始信息字典。
 *
 * @param rawInfo 包含原始打印机信息的字典。
 *
 * \~Chinese-Traditional
 * @brief 設置原始信息字典。
 *
 * @param rawInfo 包含原始打印機信息的字典。
 */
- (void)setRawInfoWithDictionary:(NSDictionary<NSString *, NSString *> *)rawInfo;

/**
 * \~English
 * @brief Gets the model of the printer.
 *
 * @return A string representing the printer model.
 *
 * \~Chinese
 * @brief 获取打印机的型号。
 *
 * @return 表示打印机型号的字符串。
 *
 * \~Chinese-Traditional
 * @brief 獲取打印機的型號。
 *
 * @return 表示打印機型號的字符串。
 */
- (NSString *)model;

/**
 * \~English
 * @brief Gets the serial number of the printer.
 *
 * @return A string representing the printer serial number.
 *
 * \~Chinese
 * @brief 获取打印机的序列号。
 *
 * @return 表示打印机序列号的字符串。
 *
 * \~Chinese-Traditional
 * @brief 獲取打印機的序列號。
 *
 * @return 表示打印機序列號的字符串。
 */
- (NSString *)serialNumber;

/**
 * \~English
 * @brief Gets the firmware version of the printer.
 *
 * @return A string representing the printer firmware version.
 *
 * \~Chinese
 * @brief 获取打印机的固件版本。
 *
 * @return 表示打印机固件版本的字符串。
 *
 * \~Chinese-Traditional
 * @brief 獲取打印機的固件版本。
 *
 * @return 表示打印機固件版本的字符串。
 */
- (NSString *)firmwareVersion;

/**
 * \~English
 * @brief Gets the firmware part number of the printer.
 *
 * @return A string representing the printer firmware part number.
 *
 * \~Chinese
 * @brief 获取打印机的固件部件号。
 *
 * @return 表示打印机固件部件号的字符串。
 *
 * \~Chinese-Traditional
 * @brief 獲取打印機的固件部件號。
 *
 * @return 表示打印機固件部件號的字符串。
 */
- (NSString *)firmwarePartNumber;

/**
 * \~English
 * @brief Gets the printhead resolution of the printer.
 *
 * @return A string representing the printhead resolution.
 *
 * \~Chinese
 * @brief 获取打印机打印头的分辨率。
 *
 * @return 表示打印头分辨率的字符串。
 *
 * \~Chinese-Traditional
 * @brief 獲取打印機打印頭的分辨率。
 *
 * @return 表示打印頭分辨率的字符串。
 */
- (NSString *)printheadResolution;

/**
 * \~English
 * @brief Checks if the printer has the ODV (Optical Disc Verification) option.
 *
 * @return YES if the printer has the ODV option, NO otherwise.
 *
 * \~Chinese
 * @brief 检查打印机是否具有 ODV（光盘验证）选项。
 *
 * @return 如果打印机具有 ODV 选项，则返回 YES，否则返回 NO。
 *
 * \~Chinese-Traditional
 * @brief 檢查打印機是否具有 ODV（光盤驗證）選項。
 *
 * @return 如果打印機具有 ODV 選項，則返回 YES，否則返回 NO。
 */
- (BOOL)hasOdvOption;

/**
 * \~English
 * @brief Checks if the printer has the RFID option.
 *
 * @return YES if the printer has the RFID option, NO otherwise.
 *
 * \~Chinese
 * @brief 检查打印机是否具有 RFID 选项。
 *
 * @return 如果打印机具有 RFID 选项，则返回 YES，否则返回 NO。
 *
 * \~Chinese-Traditional
 * @brief 檢查打印機是否具有 RFID 選項。
 *
 * @return 如果打印機具有 RFID 選項，則返回 YES，否則返回 NO。
 */
- (BOOL)hasRfidOption;

/**
 * \~English
 * @brief Checks if the printer has the clock option.
 *
 * @return YES if the printer has the clock option, NO otherwise.
 *
 * \~Chinese
 * @brief 检查打印机是否具有时钟选项。
 *
 * @return 如果打印机具有时钟选项，则返回 YES，否则返回 NO。
 *
 * \~Chinese-Traditional
 * @brief 檢查打印機是否具有時鐘選項。
 *
 * @return 如果打印機具有時鐘選項，則返回 YES，否則返回 NO。
 */
- (BOOL)hasClockOption;

@end
