#import <Foundation/Foundation.h>
@import UniPRT;

int main(int argc, const char * argv[]) {
    @autoreleasepool {
        NSString *ipAddress = @"10.0.10.170";
        TcpComm *tcpComm = [[TcpComm alloc] initWithIPAddress:ipAddress port:3007];
        [tcpComm open];

        PrinterMonitor *printerMonitor = [[PrinterMonitor alloc] initWithTcpComm:tcpComm];

        int choice = 0;
        do {
            NSLog(@"\nMenu:");
            NSLog(@"1 - Get Printer Info");
            NSLog(@"2 - Listen to Engine Status");
            NSLog(@"3 - Listen to Display Status");
            NSLog(@"4 - Listen to Alert Status");
            NSLog(@"5 - Print example file");
            NSLog(@"6 - Exit");
            NSLog(@"Enter your choice (1-6):");

            char buffer[10];
            fgets(buffer, 10, stdin);
            choice = atoi(buffer);

            switch (choice) {
                case 1: {
                    PrinterInfo *prtInfo = [printerMonitor getPrinterInfo];
                    NSLog(@"Printer Model: %@", [prtInfo model]);
                    NSLog(@"Printer SN: %@", [prtInfo serialNumber]);
                    NSLog(@"Printer FW PN: %@", [prtInfo firmwarePartNumber]);
                    NSLog(@"Printer FW Ver: %@", [prtInfo firmwareVersion]);
                    NSLog(@"Printhead Resolution (Dots/Inch): %@", [prtInfo printheadResolution]);
                    NSLog(@"Has RFID: %@", [prtInfo hasRfidOption] ? @"Yes" : @"No");
                    NSLog(@"Has ODV: %@", [prtInfo hasOdvOption] ? @"Yes" : @"No");
                    break;
                }
                case 2: {
                    [NSThread detachNewThreadWithBlock:^{
                        printerMonitor.engineStatusCallback = ^(NSString *status) {
                            NSLog(@"Engine status update: %@", status);
                        };
                        [printerMonitor SetEngineStatusListening:YES];
                    }];
                    break;
                }
                case 3: {
                    [NSThread detachNewThreadWithBlock:^{
                        printerMonitor.displayStatusCallback = ^(NSArray<NSString *> *status) {
                            NSLog(@"Display status update: %@", [status componentsJoinedByString:@", "]);
                        };
                        [printerMonitor SetDisplayStatusListening:YES];
                    }];
                    break;
                }
                case 4: {
                    [NSThread detachNewThreadWithBlock:^{
                        printerMonitor.alertStatusCallback = ^(NSArray<NSString *> *status) {
                            NSLog(@"Alert status update: %@", [status componentsJoinedByString:@", "]);
                        };
                        [printerMonitor SetAlertStatusListening:YES];
                    }];
                    break;
                }
                case 5: {
                    TcpComm *tcpComm2 = [[TcpComm alloc] initWithIPAddress:@"10.0.10.186" port:9100];
                    [tcpComm2 open];
                    [tcpComm2 sendPrintFile:@"10.0.10.186" fileName:@"/Users/realbuber/Documents/doc/TestPrinterMonitor/Hello_1.pgl"];
                    NSLog(@"Print file sent.");
                    break;
                }
                case 6:
                    NSLog(@"Exiting...");
                    break;
                default:
                    NSLog(@"Invalid choice. Please enter a number between 1 and 6.");
            }
        } while (choice != 6);
    }
    return 0;
}
