//
//  ALine.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/8.
//

#ifndef ALine_h
#define ALine_h

// ALine.h
#import <Foundation/Foundation.h>

#import <UniPRT/ILine.h>
#import <UniPRT/IPoint.h>
#import <UniPRT/IRuler.h>

/**
 * \~English
 * @class ALine
 * @brief Base class for lines.
 * @ingroup Interface
 *
 * \~Chinese
 * @class ALine
 * @brief 线的基类。
 * @ingroup Interface
 *
 * \~Chinese-Traditional
 * @class ALine
 * @brief 線的基類。
 * @ingroup Interface
 */
@interface ALine : NSObject <ILine>

/**
 * \~English
 * @brief The ruler used for placement. If not set, the default ruler setting is used.
 *
 * \~Chinese
 * @brief 用于放置的标尺。如果未设置，则使用默认的标尺设置。
 *
 * \~Chinese-Traditional
 * @brief 用於放置的標尺。如果未設置，則使用默認的標尺設置。
 */
@property (nonatomic, strong) id<IRuler> ruler;

/**
 * \~English
 * @brief Starting point of the line.
 *
 * \~Chinese
 * @brief 线的起点。
 *
 * \~Chinese-Traditional
 * @brief 線的起點。
 */
@property (nonatomic, strong) id<IPoint> start;

/**
 * \~English
 * @brief Ending point of the line.
 *
 * \~Chinese
 * @brief 线的终点。
 *
 * \~Chinese-Traditional
 * @brief 線的終點。
 */
@property (nonatomic, strong) id<IPoint> end;

/**
 * \~English
 * @brief Thickness of the line.
 *
 * \~Chinese
 * @brief 线的厚度。
 *
 * \~Chinese-Traditional
 * @brief 線的厚度。
 */
@property (nonatomic, assign) float lineThickness;

/**
 * \~English
 * @brief Initializes a new instance of ALine with specified start and end points and line thickness.
 *
 * @param start The starting point of the line.
 * @param end The ending point of the line.
 * @param lineThickness The thickness of the line.
 * @return A new instance of ALine.
 *
 * \~Chinese
 * @brief 使用指定的起点、终点和线厚度初始化 ALine 的新实例。
 *
 * @param start 线的起点。
 * @param end 线的终点。
 * @param lineThickness 线的厚度。
 * @return ALine 的新实例。
 *
 * \~Chinese-Traditional
 * @brief 使用指定的起點、終點和線厚度初始化 ALine 的新實例。
 *
 * @param start 線的起點。
 * @param end 線的終點。
 * @param lineThickness 線的厚度。
 * @return ALine 的新實例。
 */
- (instancetype)initWithStart:(id<IPoint>)start end:(id<IPoint>)end lineThickness:(float)lineThickness;

/**
 * \~English
 * @brief Returns a string representation of the line for debugging purposes.
 *
 * \~Chinese
 * @brief 返回该线条的字符串表示形式，用于调试。
 *
 * \~Chinese-Traditional
 * @brief 返回該線條的字符串表示形式，用於調試。
 */
- (NSString *)description;

@end

#endif /* ALine_h */
