//
//  PglRfid_Write.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/27.
//

#ifndef PglRfid_Write_h
#define PglRfid_Write_h

#import <Foundation/Foundation.h>
#import <UniPRT/ARfidWrite.h>
#import <UniPRT/RfidMemBlockEnum.h>
#import <UniPRT/RfidPasswordTypeEnum.h>

/**
 * \~English
 * @class PglRfid_Write
 * @brief A class representing an RFID write operation.
 *
 * This class inherits from ARfidWrite and provides functionality for initializing and describing an RFID write operation.
 *
 * @ingroup PGL
 *
 * \~Chinese
 * @class PglRfid_Write
 * @brief 表示 RFID 写操作的类。
 *
 * 该类继承自 ARfidWrite，并提供了初始化和描述 RFID 写操作的功能。
 *
 * @ingroup PGL
 *
 * \~Chinese-Traditional
 * @class PglRfid_Write
 * @brief 表示 RFID 寫操作的類。
 *
 * 該類繼承自 ARfidWrite，並提供了初始化和描述 RFID 寫操作的功能。
 *
 * @ingroup PGL
 */
@interface PglRfid_Write : ARfidWrite

/**
 * \~English
 * @brief Initializes a new instance of the PglRfid_Write class with the specified memory block and data.
 *
 * @param memBlock The memory block to write to.
 * @param data The data to be written.
 * @return A new instance of PglRfid_Write.
 *
 * \~Chinese
 * @brief 使用指定的内存块和数据初始化 PglRfid_Write 类的新实例。
 *
 * @param memBlock 要写入的内存块。
 * @param data 要写入的数据。
 * @return PglRfid_Write 的新实例。
 *
 * \~Chinese-Traditional
 * @brief 使用指定的內存塊和數據初始化 PglRfid_Write 類的新實例。
 *
 * @param memBlock 要寫入的內存塊。
 * @param data 要寫入的數據。
 * @return PglRfid_Write 的新實例。
 */
- (instancetype)initWithMemBlock:(RfidMemBlockEnum)memBlock data:(NSString *)data;

/**
 * \~English
 * @brief Returns a string that can be sent to the printer.
 *
 * This method generates a string representation of the PglRfid_Write instance that
 * is formatted and ready to be sent to a printer. The string includes all the
 * necessary commands and data required for printing.
 *
 * @return A string description of the PglRfid_Write instance.
 *
 * \~Chinese
 * @brief 返回可以发送到打印机的字符串。
 *
 * 该方法生成 PglRfid_Write 实例的字符串表示形式，
 * 格式化并准备好发送到打印机。字符串包括打印所需的所有命令和数据。
 *
 * @return PglRfid_Write 实例的字符串描述。
 *
 * \~Chinese-Traditional
 * @brief 返回可以發送到打印機的字符串。
 *
 * 該方法生成 PglRfid_Write 實例的字符串表示形式，
 * 格式化並準備好發送到打印機。字符串包括打印所需的所有命令和數據。
 *
 * @return PglRfid_Write 實例的字符串描述。
 */
- (NSString *)description;

@end

#endif /* PglRfid_Write_h */
