//
//  Translate.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/15.
//

#ifndef Translate_h
#define Translate_h

#import <Foundation/Foundation.h>

#import <UniPRT/TSPL.h>
#import <UniPRT/QRCodeModelEnum.h>
#import <UniPRT/QRCodeErrorCorrectionEnum.h>
#import <UniPRT/QRCodeManualEncodingEnum.h>
#import <UniPRT/RfidMemBlockEnum.h>
#import <UniPRT/RfidPasswordTypeEnum.h>
#import <UniPRT/RotateEnum.h>
#import <UniPRT/AlignEnum.h>
#import <UniPRT/BarcodeTypeEnum_1D.h>

/** @cond */

@interface Translate : NSObject

+ (TSPLRotation)rotationWithEnum:(RotateEnum)rotation;
+ (TSPLAlignEnum)alignmentWithEnum:(AlignEnum)align;
+ (TSPLBarcodeType1D)barcodeType1DWithEnum:(BarcodeTypeEnum1D)barcodeType;
+ (int)qrCodeModelWithEnum:(QRCodeModelEnum)model;
+ (int)qrCodeErrCorrectionWithEnum:(QRCodeErrorCorrectionEnum)errCorr;
+ (char)qrCodeEncodingWithEnum:(QRCodeManualEncodingEnum)manualEncodeType;
+ (NSString *)rfidMemBlockWithEnum:(RfidMemBlockEnum)memBlockSelect;
+ (NSString *)rfidLockTypeWithEnum:(RfidPasswordTypeEnum)lockType;

@end

/** @endcond */

#endif /* Translate_h */
