//
//  ABarcode.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/7.
//

#ifndef ABarcode_h
#define ABarcode_h

#import <Foundation/Foundation.h>
#import <UniPRT/IBarcode2D.h>

/**
 * @~english
 * @class ABarcode2D
 * @brief Base class for ABarcode2D barcode.
 * @ingroup Interface
 *
 * @~chinese
 * @class ABarcode2D
 * @brief ABarcode2D 条码的基类。
 * @ingroup Interface
 *
 * @~Chinese-Traditional
 * @class ABarcode2D
 * @brief ABarcode2D 條碼的基類。
 * @ingroup Interface
 */

@interface ABarcode2D : NSObject <IBarcode2D>

@property (nonatomic, strong) id<IRuler> ruler;
@property (nonatomic, strong) id<IPoint> start;
@property (nonatomic, strong) NSString *data;
@property (nonatomic) RotateEnum rotation;

- (NSString *)description NS_REQUIRES_SUPER;

@end


#endif /* ABarcode_h */
