//
//  ARfidWrite.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/8.
//

#ifndef ARfidWrite_h
#define ARfidWrite_h

// ARfidWrite.h
#import <Foundation/Foundation.h>

#import <AutoIdSDK/IRfidBankSelect.h>
#import <AutoIdSDK/IRfidBitField.h>
#import <AutoIdSDK/IRfidPassword.h>

// Define an abstract class interface
@interface ARfidWrite : NSObject <IRfidBankSelect, IRfidBitField, IRfidPassword>

@property (nonatomic, assign) RfidMemBlockEnum memory; // from IRfidBankSelect
@property (nonatomic, strong) NSString *password; // from IRfidPassword
@property (nonatomic, assign) RfidPasswordTypeEnum passwordType; // from IRfidPassword
@property (nonatomic, assign) int offsetFromStart; // from IRfidBitField
@property (nonatomic, strong) NSString *data; // from IRfidBitField

// Designated initializers
- (instancetype)init NS_DESIGNATED_INITIALIZER;
- (instancetype)initWithMemBlock:(RfidMemBlockEnum)memBlock data:(NSString *)data NS_DESIGNATED_INITIALIZER;

// Abstract method
- (NSString *)description; // Must be overridden in subclasses

@end

#endif /* ARfidWrite_h */
