//
//  JsonConfig.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/4/19.
//

#ifndef JsonConfig_h
#define JsonConfig_h


#endif /* JsonConfig_h */

// JsonConfig.h

#import <Foundation/Foundation.h>
#import <AutoIdSDK/Config.h>

// Assuming JsonComm and Config are already translated Objective-C classes
@class JsonComm;
@class Config;

/**
 * @class JsonConfig
 * @brief A class for managing configuration through JSON communication.
 * @ingroup JSONMng
 */
@interface JsonConfig : NSObject

// Initializers
/**
 * @brief Initializes a new instance with the given TCP communication object.
 *
 * @param connection The TCP communication object.
 * @return An initialized instance of JsonConfig, or nil if the object could not be created.
 */
- (instancetype)initWithTcpComm:(id)connection;

/**
 * @brief Initializes a new instance with the given JSON communication object.
 *
 * @param mgmtComm The JSON communication object.
 * @return An initialized instance of JsonConfig, or nil if the object could not be created.
 */
- (instancetype)initWithJsonComm:(JsonComm *)mgmtComm;

/**
 * @brief Initializes a new instance with the given communication descriptor.
 *
 * @param commDescriptor The communication descriptor.
 * @return An initialized instance of JsonConfig, or nil if the object could not be created.
 */
- (instancetype)initWithCommDescriptor:(NSString *)commDescriptor;

// Destructor
/**
 * @brief Destructor for the JsonConfig object.
 */
- (void)dealloc;

// Methods
/**
 * @brief Disposes the object, releasing any resources.
 */
- (void)dispose;

/**
 * @brief Gets all configurations.
 *
 * @return An array of Config objects representing all configurations.
 */
- (NSArray<Config *> *)getAllConfig;

/**
 * @brief Gets the configuration with the specified number.
 *
 * @param cfgNumber The number of the configuration to retrieve.
 * @param pCfg A pointer to a Config object where the configuration will be stored.
 */
- (void)getConfigWithNumber:(int)cfgNumber config:(Config **)pCfg;

/**
 * @brief Sets the specified configuration.
 *
 * @param pCfg The Config object representing the configuration to set.
 * @return YES if the configuration was successfully set, NO otherwise.
 */
- (BOOL)setConfig:(Config *)pCfg;

@end

