//
//  JsonConnection.h
//  TSCPrinters SDK
//
//  Created by Realbuber on 2024/4/8.
//

#ifndef JsonConnection_h
#define JsonConnection_h


#endif /* JsonConnection_h */

#import <Foundation/Foundation.h>
#import <AutoIdSDK/TcpComm.h>
#import <AutoIdSDK/JsonComm.h>


/**
 * @class JsonConnection
 * @brief A class for managing a JSON-based communication connection.
 * @ingroup JSONComm
 */
@interface JsonConnection : NSObject {
    NSInteger _userCount;      /**< The number of users connected. */
    NSString *_descriptor;     /**< The descriptor for the connection. */
    TcpComm *_tcpComm;         /**< The TCP communication instance. */
    JsonComm *_jsonComm;       /**< The JSON communication instance. */
    BOOL _disposed;            /**< A flag indicating whether the connection is disposed. */
}

/**
 * @brief Initializes a new instance with the given communication descriptor.
 *
 * @param commDescriptor The descriptor for the communication.
 * @return An initialized instance of JsonConnection, or nil if the object could not be created.
 */
- (instancetype)initWithCommDescriptor:(NSString *)commDescriptor;

/**
 * @brief Adds a user to the connection.
 *
 * @return The updated user count.
 */
- (NSInteger)addUser;

/**
 * @brief Removes a user from the connection.
 *
 * @return The updated user count.
 */
- (NSInteger)removeUser;

/**
 * @brief Gets the current user count.
 *
 * @return The current user count.
 */
- (NSInteger)getUserCount;

/**
 * @brief Gets the descriptor for the connection.
 *
 * @return The descriptor string.
 */
- (NSString *)getDescriptor;

/**
 * @brief Disposes the connection, releasing any resources.
 */
- (void)dispose;

/**
 * @brief Gets the TCP communication instance.
 *
 * @return A pointer to the TcpComm instance.
 */
- (TcpComm *)getPtrComm;

/**
 * @brief Gets the JSON communication instance.
 *
 * @return A pointer to the JsonComm instance.
 */
- (JsonComm *)getJsonComm;

@end

