//
//  PglBarcode1D.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/23.
//

#ifndef PglBarcode1D_h
#define PglBarcode1D_h

#import <Foundation/Foundation.h>

#import <AutoIdSDK/PglCmd.h>
#import <AutoIdSDK/PGL.h>
#import <AutoIdSDK/PglBarcode1DProperties.h>

NS_ASSUME_NONNULL_BEGIN

@interface PglBarcode1D : NSObject

@property (nonatomic, copy) NSString *magnification;
@property (nonatomic, assign) float height;
@property (nonatomic, assign) PGLRotation rotation;
@property (nonatomic, assign) BOOL pdf;
@property (nonatomic, assign) BOOL pdfLocTop;
@property (nonatomic, copy) NSString *data;
@property (nonatomic, assign) int sr;
@property (nonatomic, assign) int sc;
@property (nonatomic, assign) PGLBarcodeType1D bcdType;

- (instancetype)initWithBcdType:(PGLBarcodeType1D)bcdType SR:(int)sr SC:(int)sc data:(NSString *)data;
- (instancetype)initWithBcdProps:(PglBarcode1DProperties *)bcdProps SR:(int)sr SC:(int)sc data:(NSString *)data;
- (NSString *)description;

@end

NS_ASSUME_NONNULL_END

#endif /* PglBarcode1D_h */
