//
//  PrinterInfo.h
//  TSCPrinters SDK
//
//  Created by Realbuber on 2024/4/10.
//

#ifndef PrinterInfo_h
#define PrinterInfo_h


#endif /* PrinterInfo_h */
#import <Foundation/Foundation.h>

/**
 * @class PrinterInfo
 * @brief A class for accessing and managing printer information.
 * @ingroup Monitor
 */
@interface PrinterInfo : NSObject

/**
 * @brief The raw information dictionary containing printer details.
 */
@property (nonatomic, strong, readonly) NSDictionary<NSString *, NSString *> *rawInfo;

/**
 * @brief Sets the raw information dictionary.
 *
 * @param rawInfo The dictionary containing the raw printer information.
 */
- (void)setRawInfoWithDictionary:(NSDictionary<NSString *, NSString *> *)rawInfo;

/**
 * @brief Gets the model of the printer.
 *
 * @return A string representing the printer model.
 */
- (NSString *)model;

/**
 * @brief Gets the serial number of the printer.
 *
 * @return A string representing the printer serial number.
 */
- (NSString *)serialNumber;

/**
 * @brief Gets the firmware version of the printer.
 *
 * @return A string representing the printer firmware version.
 */
- (NSString *)firmwareVersion;

/**
 * @brief Gets the firmware part number of the printer.
 *
 * @return A string representing the printer firmware part number.
 */
- (NSString *)firmwarePartNumber;

/**
 * @brief Gets the printhead resolution of the printer.
 *
 * @return A string representing the printhead resolution.
 */
- (NSString *)printheadResolution;

/**
 * @brief Checks if the printer has the ODV (Optical Disc Verification) option.
 *
 * @return YES if the printer has the ODV option, NO otherwise.
 */
- (BOOL)hasOdvOption;

/**
 * @brief Checks if the printer has the RFID option.
 *
 * @return YES if the printer has the RFID option, NO otherwise.
 */
- (BOOL)hasRfidOption;

/**
 * @brief Checks if the printer has the clock option.
 *
 * @return YES if the printer has the clock option, NO otherwise.
 */
- (BOOL)hasClockOption;

@end
