//
//  ISquareCell.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/7.
//

#ifndef ISquareCell_h
#define ISquareCell_h

#import <Foundation/Foundation.h>
#import <UniPRT/ICellSquare.h>

/**
 * @~english
 * @protocol ISquareCell
 * @brief A protocol defining the interface for SquareCell classes.
 * @ingroup Interface
 *
 * @~chinese
 * @protocol ISquareCell
 * @brief 定义正方形单元类接口的协议。
 * @ingroup Interface
 *
 * @~Chinese-Traditional
 * @protocol ISquareCell
 * @brief 定義正方形單元類接口的協議。
 * @ingroup Interface
 */
@protocol ISquareCell <NSObject>

/**
 * @~english
 * @brief Barcode cell size. Larger cell size results in barcodes that take up a larger area.
 *
 * @~chinese
 * @brief 条码单元大小。较大的单元大小会使条码占用更大的面积。
 *
 * @~Chinese-Traditional
 * @brief 條碼單元大小。較大的單元大小會使條碼占用更大的面積。
 */
@property (nonatomic, strong) id<ICellSquare> cellSize;

@end

#endif /* ISquareCell_h */
